/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.PopupWindow;
import DE.siemens.ad.logo.app.comp.RolloverButton;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.app.comp.ToolBarLayout;
import DE.siemens.ad.logo.dialog.comp.BlockListCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.AIDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.BarDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.BarDisplaySettingPanel;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayToolTipProvider;
import DE.siemens.ad.logo.dialog.comp.display.IONameDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.IONameSettingPanel;
import DE.siemens.ad.logo.dialog.comp.display.LogoDisplay;
import DE.siemens.ad.logo.dialog.comp.display.MessageDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.MessageParameterDisplayModelPlain;
import DE.siemens.ad.logo.dialog.comp.display.MessageParameterDisplayModelRTF;
import DE.siemens.ad.logo.dialog.comp.display.MessageResource;
import DE.siemens.ad.logo.dialog.comp.display.MutiCharSetDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.OneCharacterCellEditor;
import DE.siemens.ad.logo.dialog.comp.display.ScaleTimeDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.ScaleTimeSettingPanel;
import DE.siemens.ad.logo.dialog.comp.display.SpecialCharacterDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.SymbolInsertPanel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.MessageManager;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ProtectionParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.panel.AbstractProtectionPanel;
import DE.siemens.ad.logo.model.panel.MessageEditorPanel;
import DE.siemens.ad.logo.util.BlockByNumberComparator;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.MessageGlobalInfo;
import DE.siemens.ad.logo.util.MessageLineRTF;
import DE.siemens.ad.pdraw.app.LogoComfort;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MessagePanel
extends AbstractProtectionPanel {
    private static final long serialVersionUID = 2L;
    private PopupWindow fInsertSpecialCharacterPopupWindow;
    protected JPanel fParameterPanel;
    protected BorderJPanel fBjpParameterList;
    protected BorderJPanel fBjpBlockList;
    protected JButton fBtInsertParameterItemButton;
    protected JList fLstBlockList;
    protected JList fLstParameterItemList;
    protected JList fLstMessageInternParameterItemList;
    protected JComboBox fCoBoPriority;
    protected JLabel fLblPriority;
    protected JCheckBox fChBoReceipt;
    protected JRadioButton[] fOptionTickTypes;
    protected JCheckBox[] fChkLineTickerFlags;
    protected JRadioButton[] fOptionDest;
    protected JRadioButton[] fCurrentlyCharacterSet;
    protected JCheckBox[] fChkCharSetEnabled;
    protected int[] fTextID;
    private int fPanelTextID = -1;
    protected BorderJPanel fBjpLogoDisplay;
    protected LogoDisplay fLogoDisplay;
    protected MessageDisplayModel fDisplayModel;
    private SymbolInsertPanel fSymbolPanel;
    private LogoDisplay.CellsTransferable fCellsTransferable;
    protected JButton fBtClearButton;
    protected JButton fBtInsertSpecialCharacter;
    protected JButton fBtInsertBarButton;
    protected JButton fBtInsertAIButton;
    protected JButton fBtInsertIONameButton;
    protected JButton fBtInsertSymbolButton;
    protected JButton fBtEditorButton;
    protected JButton fBtMessageMenu;
    protected JButton fBtScaleTime;
    private JPanel fInsertSpecialCharactersPanel;
    private JLabel fOverwriteInsertLabel;
    private ControlsSettingInfo[] fSettingInfo;
    private JCheckBox fChkPrintDetail = new JCheckBox();

    public boolean checkFieldContents() {
        return super.checkFieldContents();
    }

    public boolean checkChanged() {
        return true;
    }

    protected void setPriorityValues() {
        MessageParameter parameter = (MessageParameter)this.getParameterReference();
        Vector newPriorities = parameter.getBlock().getWiringDiagram().getMessageManager().getFreePriorities();
        Integer priority = parameter.getPriority();
        int size = newPriorities.size();
        for (int i = 0; i < size; ++i) {
            if (((Integer)newPriorities.elementAt(i)).compareTo(priority) <= 0) continue;
            newPriorities.insertElementAt(priority, i);
            break;
        }
        if (newPriorities.size() == size) {
            newPriorities.addElement(priority);
        }
        DefaultComboBoxModel model = new DefaultComboBoxModel(newPriorities);
        this.fCoBoPriority.setModel(model);
        model.setSelectedItem(parameter.getPriority());
    }

    protected void fillParameterList() {
        Block block = (Block)this.fLstBlockList.getSelectedValue();
        BlockParameter blockParameter = block.getParameter();
        Vector<ParameterItem> concreteParameterItems = new Vector<ParameterItem>();
        for (ParameterItem parameterItem : blockParameter.getParameterItems().getPublicParameterItemList()) {
            concreteParameterItems.add(parameterItem.getInstanceForParameter(block.getParameter()));
        }
        this.fLstParameterItemList.setListData(concreteParameterItems);
    }

    protected void fillPrivateParameterList() {
        BlockParameter blockParameter = (BlockParameter)this.fParameterReference;
        Vector<ParameterItem> concreteParameterItems = new Vector<ParameterItem>();
        for (ParameterItem parameterItem : blockParameter.getParameterItems().getPrivateParameterItemList()) {
            if (parameterItem.getParameterNumber() < 0) continue;
            concreteParameterItems.add(parameterItem.getInstanceForParameter(blockParameter));
        }
        this.fLstMessageInternParameterItemList.setListData(concreteParameterItems);
    }

    public void setLabels() {
        super.setLabels();
        this.fBjpLogoDisplay.setTitle(Language.getString("dialog.parameter.message.messageBorder", "Display"));
        this.fBjpBlockList.setTitle(Language.getString("dialog.parameter.message.blockBorder", "Block"));
        this.fBjpParameterList.setTitle(Language.getString("dialog.parameter.message.blockParameterBorder", "Parameter"));
        this.fLblPriority.setText(Language.getString("dialog.parameter.message.priority", "Priority"));
        this.fChBoReceipt.setText(Language.getString("dialog.parameter.message.receipt", "Receipt notification"));
        this.fBtInsertParameterItemButton.setText(Language.getString("dialog.parameter.message.insert", "Insert"));
        this.fOverwriteInsertLabel.setText(Language.getString("dialog.parameter.message.overwrite", "Overwrite"));
        this.fBtEditorButton.setText(Language.getString("dialog.parameter.message.EditManually", "Edit manually"));
        this.fBtInsertSymbolButton.setText(Language.getString("dialog.parameter.message.symbol", "Symbol"));
        this.fBtMessageMenu.setText(Language.getString("dialog.parameter.message.gotoMessageMenu", "Enable New Feature"));
        if (this.isRTFMessage()) {
            this.fOptionTickTypes[0].setText(Language.getString("dialog.parameter.message.tickerType0", "By character"));
            this.fOptionTickTypes[1].setText(Language.getString("dialog.parameter.message.tickerType1", "By line"));
            for (int i = 0; i < this.fChkLineTickerFlags.length; ++i) {
                this.fChkLineTickerFlags[i].setText(Language.getString("dialog.parameter.message.tickerLine", "Line") + (i + 1));
            }
            this.fOptionDest[0].setText(Language.getString("dialog.parameter.message.showDest0", "display?"));
            this.fOptionDest[1].setText(Language.getString("dialog.parameter.message.showDest1", "TD?"));
            this.fOptionDest[2].setText(Language.getString("dialog.parameter.message.showDest2", "both?"));
            this.fCurrentlyCharacterSet[0].setText(this.getLanguageString(0));
            this.fCurrentlyCharacterSet[1].setText(this.getLanguageString(1));
            this.fChkCharSetEnabled[0].setText(Language.getString("dialog.parameter.message.charSetSetEnabled", "En?"));
            this.fChkCharSetEnabled[1].setText(Language.getString("dialog.parameter.message.charSetSetEnabled", "En?"));
            this.fChkPrintDetail.setText(Language.getString("dialog.parameter.message.parameterTextMode", "Show detail?"));
            MessageParameter parameter = (MessageParameter)this.getParameterReference();
            if (!parameter.getBlock().getHardware().supports("supportScaleTime")) {
                this.fBtScaleTime.setEnabled(false);
            }
        } else {
            this.fBtInsertBarButton.setEnabled(false);
            this.fBtInsertAIButton.setEnabled(false);
            this.fBtInsertIONameButton.setEnabled(false);
            this.fBtEditorButton.setEnabled(false);
            this.fBtInsertSymbolButton.setEnabled(false);
            this.fBtScaleTime.setEnabled(false);
        }
        this.fCoBoPriority.setToolTipText(Language.getString("dialog.parameter.message.priorityTip", "Higher value = higher priority"));
        this.fChBoReceipt.setToolTipText(Language.getString("dialog.parameter.message.receiptTip", "If checked, user must receipt every notification"));
        this.fLstParameterItemList.setToolTipText(Language.getString("dialog.parameter.message.parameterList.tootip", "Doubleclick or drag the parameter into the message"));
        this.fLstMessageInternParameterItemList.setToolTipText(Language.getString("dialog.parameter.message.parameterList.tootip", "Doubleclick or drag the parameter into the message"));
        this.fBtInsertParameterItemButton.setToolTipText(Language.getString("dialog.parameter.message.insertButton.tooltip", "Inserts the selected parameter into the message"));
        this.fBtClearButton.setToolTipText(Language.getStringNoTilde("edit.delete", "clear selection"));
        this.fBtInsertSpecialCharacter.setToolTipText(Language.getString("dialog.parameter.message.insertSpecialCharacter", "Insert special character"));
        this.fOverwriteInsertLabel.setToolTipText(Language.getString("dialog.messageDisplay.tooltip.doubleClickToEdit", "Doubleclick to change"));
        this.fBtInsertBarButton.setToolTipText(Language.getString("dialog.parameter.message.barButtonTip", "Insert a bar-graph into the message"));
        this.fBtInsertAIButton.setToolTipText(Language.getString("dialog.parameter.message.AIButtonTip", "Insert an AI filter into the message"));
        this.fBtInsertIONameButton.setToolTipText(Language.getString("dialog.parameter.message.IONameButtonTip", "Insert an IO status name into the message"));
        this.fBtInsertSymbolButton.setToolTipText(Language.getString("dialog.parameter.message.symbolButtonTip", "Insert an Symbol into the message"));
        this.fBtEditorButton.setToolTipText(Language.getString("dialog.parameter.message.EditManuallyTip", "Arrange the messageText manually"));
        this.fBtMessageMenu.setToolTipText(Language.getString("dialog.parameter.message.gotoMessageMenuTip", "Use new style message"));
        this.fBtScaleTime.setToolTipText(Language.getString("dialog.parameter.message.scaleTimeTip", "Insert a scale time into the message"));
    }

    private String getLanguageString(int charSetID) {
        int charSet = this.getMsgGlobalInfo().getSelectedCharSet(charSetID);
        return Language.getString("dialog.parameter.message.charSetText", "Text?") + " " + (charSetID + 1) + ": " + MessageGlobalInfo.getCharSetName(charSet);
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        MessageParameter parameter = (MessageParameter)this.getParameterReference();
        parameter.setPriority((Integer)this.fCoBoPriority.getSelectedItem());
        this.setPriorityValues();
        parameter.setReceipt(this.fChBoReceipt.isSelected());
        if (this.isRTFMessage()) {
            int i;
            parameter.setCurrentTextID(this.fPanelTextID);
            ((MessageParameter)this.getParameterReference()).setCurrentTextID(this.fPanelTextID);
            this.fSettingInfo[this.fPanelTextID].saveControlsStatus();
            for (i = 0; i < 2; ++i) {
                if (this.fSettingInfo[i] == null) continue;
                this.fSettingInfo[i].storeInfoToParameter(parameter);
            }
            for (i = 0; i < 2; ++i) {
                if (this.fSettingInfo[i] != null || ((MessageParameter)this.getParameterReference()).getMessageRTF(i) == null) continue;
                ((MessageParameter)this.getParameterReference()).disableTextRTF(i);
            }
            parameter.setParameterTextMode(this.fChkPrintDetail.isSelected());
        } else {
            MessageManager.fillMessageLinesFromDisplayModel(parameter, this.fDisplayModel);
        }
    }

    public MessagePanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        this.globalParamPane.add(this.fChkPrintDetail);
        this.fBtMessageMenu = new JButton();
        if (this.isRTFMessage()) {
            this.initComponentsRTF();
            this.fChkPrintDetail.setVisible(true);
        } else {
            this.initComponents();
            this.fChkPrintDetail.setVisible(false);
        }
        this.addParameterPane(this.getParameterPanel());
    }

    public String getHelpIdString() {
        if (this.isRTFMessage()) {
            return super.getHelpIdString();
        }
        return super.getHelpIdString() + ".plain";
    }

    private void addSubPanels(JPanel pane, int gridx, int gridy, int gridwidth, int gridHeight) {
        this.addSubPanels(pane, gridx, gridy, gridwidth, gridHeight, 0, 0);
    }

    private void addSubPanels(JPanel pane, int gridx, int gridy, int gridwidth, int gridHeight, int weightx, int weighty) {
        this.addSubPanels(this.fParameterPanel, pane, gridx, gridy, gridwidth, gridHeight, weightx, weighty);
    }

    private void addSubPanels(JPanel parent, JPanel pane, int gridx, int gridy, int gridwidth, int gridHeight) {
        this.addSubPanels(parent, pane, gridx, gridy, gridwidth, gridHeight, 0, 0);
    }

    private void addSubPanels(JPanel parent, JPanel pane, int gridx, int gridy, int gridwidth, int gridHeight, int weightx, int weighty) {
        this.addSubComponent(parent, pane, gridx, gridy, gridwidth, gridHeight, weightx, weighty, new Insets(0, 0, 0, 0));
    }

    private void addSubComponent(JPanel parent, Component pane, int gridx, int gridy, int gridwidth, int gridHeight, int weightx, int weighty, Insets insets) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridheight = gridHeight;
        gbc.gridwidth = gridwidth;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = insets;
        parent.add(pane, gbc);
    }

    private void initComponents() {
        this.fParameterPanel = new JPanel(new GridBagLayout());
        boolean width_1 = true;
        this.addSubPanels(this.getPriorityPanel(), 0, 0, 1, 1, 1, 0);
        this.addSubPanels(this.getBlockListPanel(), 0, 1, 1, 3, 1, 1);
        this.addSubPanels(this.getDisplay(), 1, 0, 1, 2);
        this.addSubPanels(this.getMessageToolbar(), 1, 2, 1, 1);
        this.addSubPanels(this.getParameterListPanel(), 1, 3, 1, 1);
        this.addSubComponent(this.fParameterPanel, this.fBtMessageMenu, 0, 4, 2, 1, 0, 0, new Insets(0, 5, 0, 5));
        this.fInsertSpecialCharactersPanel = new JPanel(new ToolBarLayout(0));
        this.initListeners();
        this.initDragAndDrop();
    }

    private void initComponentsRTF() {
        this.fParameterPanel = new JPanel(new GridBagLayout());
        boolean width_1 = true;
        BorderJPanel blockSetPanel = new BorderJPanel(new GridBagLayout());
        blockSetPanel.setTitle(Language.getString("dialog.parameter.message.blockSetting", "block setting?"));
        this.addSubComponent(blockSetPanel, this.getPriorityPanel(), 0, 0, 1, 1, 0, 1, new Insets(0, 5, 0, 5));
        this.addSubComponent(blockSetPanel, this.getCharacterSetPanel(), 1, 0, 1, 1, 1, 1, new Insets(0, 5, 0, 5));
        BorderJPanel textSetPanel = new BorderJPanel(new GridBagLayout());
        textSetPanel.setTitle(Language.getString("dialog.parameter.message.messageTextSetting", "Message Text setting?"));
        this.addSubPanels(textSetPanel, this.getTickerSettingPanel(), 0, 0, 1, 1);
        this.addSubPanels(textSetPanel, this.getDisplayDestPanel(), 0, 1, 1, 1);
        this.addSubPanels(textSetPanel, this.getBlockListPanel(), 0, 2, 1, 3, 1, 1);
        this.addSubPanels(textSetPanel, this.getDisplay(), 1, 0, 1, 3);
        this.addSubComponent(textSetPanel, this.getInsertParameterItemButton(), 1, 3, 1, 1, 0, 0, new Insets(0, 10, 0, 10));
        this.addSubPanels(textSetPanel, this.getParameterListPanel(), 1, 4, 1, 1, 0, 1);
        this.addSubPanels(blockSetPanel, 0, 0, 1, 1, 1, 0);
        this.addSubPanels(textSetPanel, 0, 1, 1, 1, 1, 1);
        this.fInsertSpecialCharactersPanel = new JPanel(new ToolBarLayout(0));
        this.initListeners();
        this.initDragAndDrop();
    }

    private JPanel getPriorityPanel() {
        JPanel priorityReceiptPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = null;
        this.fLblPriority = new JLabel("Priority");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        priorityReceiptPanel.add((Component)this.fLblPriority, gbc);
        this.fCoBoPriority = new JComboBox();
        this.fCoBoPriority.setPrototypeDisplayValue("1234");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 5, 10, 80);
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        priorityReceiptPanel.add((Component)this.fCoBoPriority, gbc);
        this.fChBoReceipt = new JCheckBox("Receipt");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.gridwidth = 2;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(10, 10, 10, 10);
        priorityReceiptPanel.add((Component)this.fChBoReceipt, gbc);
        return priorityReceiptPanel;
    }

    private JPanel getCharacterSetPanel() {
        int i;
        BorderJPanel characterSetPanel = null;
        characterSetPanel = new BorderJPanel();
        characterSetPanel.setLayout(new BoxLayout(characterSetPanel, 0));
        characterSetPanel.setTitle(Language.getString("dialog.parameter.message.charSetSettingTitle", "Current Character Set"));
        this.fCurrentlyCharacterSet = new JRadioButton[2];
        this.fChkCharSetEnabled = new JCheckBox[2];
        ButtonGroup bg1 = new ButtonGroup();
        JPanel pane_1 = new JPanel();
        pane_1.setLayout(new BoxLayout(pane_1, 1));
        characterSetPanel.add(pane_1);
        for (int i2 = 0; i2 < 2; ++i2) {
            this.fCurrentlyCharacterSet[i2] = new JRadioButton("tmp_charset" + i2);
            bg1.add(this.fCurrentlyCharacterSet[i2]);
            pane_1.add(this.fCurrentlyCharacterSet[i2]);
        }
        JPanel pane_2 = new JPanel();
        pane_2.setLayout(new BoxLayout(pane_2, 1));
        characterSetPanel.add(pane_2);
        for (i = 0; i < 2; ++i) {
            this.fChkCharSetEnabled[i] = new JCheckBox("En?");
            pane_2.add(this.fChkCharSetEnabled[i]);
        }
        this.fCurrentlyCharacterSet[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MessagePanel.this.fPanelTextID != 0) {
                    MessagePanel.this.fSettingInfo[1].saveControlsStatus();
                    MessagePanel.this.fPanelTextID = 0;
                    MessagePanel.this.fSettingInfo[0].setControlsStatus();
                }
            }
        });
        this.fCurrentlyCharacterSet[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MessagePanel.this.fPanelTextID != 1) {
                    MessagePanel.this.fSettingInfo[0].saveControlsStatus();
                    MessagePanel.this.fPanelTextID = 1;
                    MessagePanel.this.fSettingInfo[1].setControlsStatus();
                }
            }
        });
        for (i = 0; i < 2; ++i) {
            this.fChkCharSetEnabled[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int charSetID;
                    if (e.getSource() == MessagePanel.this.fChkCharSetEnabled[0]) {
                        charSetID = 0;
                    } else if (e.getSource() == MessagePanel.this.fChkCharSetEnabled[1]) {
                        charSetID = 1;
                    } else {
                        return;
                    }
                    MessagePanel.this.newOrDeleteText(charSetID);
                }
            });
        }
        return characterSetPanel;
    }

    private void newOrDeleteText(int charSetID) {
        MessageParameter param = (MessageParameter)this.getParameterReference();
        if (this.fChkCharSetEnabled[charSetID].isSelected()) {
            if (this.fTextID[charSetID] == -1) {
                Log.println(Language.getString("dialog.parameter.message.messageTextNotAvailable", "Can not create new text."));
                this.fChkCharSetEnabled[charSetID].setSelected(false);
            } else {
                this.fSettingInfo[charSetID] = new ControlsSettingInfo(param, charSetID, 0);
                this.fCurrentlyCharacterSet[charSetID].setEnabled(true);
            }
        } else if (this.fSettingInfo[1 - charSetID] == null) {
            Log.println("Only one text, you should delete the block");
            this.fChkCharSetEnabled[charSetID].setSelected(true);
        } else {
            LogoError dlg = new LogoError(null, "dialog.parameter.message.deleteTextNotify", "The text will be deleted! Are you sure to do that?", 2, 2);
            if (dlg.display() != 2) {
                this.fChkCharSetEnabled[charSetID].setSelected(true);
                return;
            }
            this.fSettingInfo[charSetID] = null;
            this.fCurrentlyCharacterSet[charSetID].setEnabled(false);
            if (charSetID == this.fPanelTextID) {
                this.fPanelTextID = 1 - charSetID;
                this.fCurrentlyCharacterSet[this.fPanelTextID].setSelected(true);
                this.fSettingInfo[this.fPanelTextID].setControlsStatus();
            }
        }
    }

    private JPanel getTickerSettingPanel() {
        int i;
        BorderJPanel tickerSettingPanel = null;
        tickerSettingPanel = new BorderJPanel();
        tickerSettingPanel.setLayout(new BoxLayout(tickerSettingPanel, 1));
        tickerSettingPanel.setTitle(Language.getString("dialog.parameter.message.tickerSetting", "ticker?"));
        JPanel tickerGridPanel = new JPanel();
        tickerGridPanel.setLayout(new BoxLayout(tickerGridPanel, 0));
        JPanel tickerLinePanel = new JPanel();
        tickerLinePanel.setLayout(new BoxLayout(tickerLinePanel, 0));
        tickerSettingPanel.add(tickerGridPanel);
        tickerSettingPanel.add(tickerLinePanel);
        this.fOptionTickTypes = new JRadioButton[2];
        ButtonGroup bg1 = new ButtonGroup();
        for (i = 0; i < 2; ++i) {
            this.fOptionTickTypes[i] = new JRadioButton("tmp_type" + i);
            tickerGridPanel.add(this.fOptionTickTypes[i]);
            bg1.add(this.fOptionTickTypes[i]);
        }
        this.fChkLineTickerFlags = new JCheckBox[4];
        for (i = 0; i < 4; ++i) {
            this.fChkLineTickerFlags[i] = new JCheckBox("tmp_line" + i);
            tickerLinePanel.add(this.fChkLineTickerFlags[i]);
        }
        return tickerSettingPanel;
    }

    private JPanel getDisplayDestPanel() {
        BorderJPanel displayDestPanel = new BorderJPanel(new FlowLayout());
        displayDestPanel.setTitle(Language.getString("dialog.parameter.message.showDestSetting", "Destination?"));
        this.fOptionDest = new JRadioButton[3];
        ButtonGroup bg1 = new ButtonGroup();
        for (int i = 0; i < this.fOptionDest.length; ++i) {
            this.fOptionDest[i] = new JRadioButton("tmp_Dest" + i);
            displayDestPanel.add(this.fOptionDest[i]);
            bg1.add(this.fOptionDest[i]);
        }
        return displayDestPanel;
    }

    private JPanel getParameterListPanel() {
        this.fBjpParameterList = new BorderJPanel(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.fLstParameterItemList = new JList();
        ParameterItemListCellRenderer parameterItemListCellRenderer = new ParameterItemListCellRenderer();
        parameterItemListCellRenderer.setHorizontalTextPosition(10);
        this.fLstParameterItemList.setCellRenderer(parameterItemListCellRenderer);
        this.fLstParameterItemList.setSelectionMode(0);
        panel.add((Component)new JScrollPane(this.fLstParameterItemList), "Center");
        this.fLstMessageInternParameterItemList = new JList();
        panel.add((Component)this.fLstMessageInternParameterItemList, "South");
        this.fBjpParameterList.add((Component)new JScrollPane(panel), "Center");
        return this.fBjpParameterList;
    }

    private JPanel getDisplay() {
        this.fBjpLogoDisplay = new BorderJPanel(new BorderLayout());
        this.fBjpLogoDisplay.add((Component)this.getMessageDisplayToolBar(), "North");
        this.fLogoDisplay = new LogoDisplay();
        this.fLogoDisplay.setToolTipProvider(new ParameteringDisplayToolTipProvider());
        this.fLogoDisplay.setCellRendererMode(LogoDisplay.MODE_DETAIL);
        this.fLogoDisplay.setDefaultCellEditor(new OneCharacterCellEditor());
        this.fBjpLogoDisplay.add(this.fLogoDisplay);
        this.fOverwriteInsertLabel = new JLabel("insert");
        this.fBjpLogoDisplay.add((Component)this.fOverwriteInsertLabel, "South");
        return this.fBjpLogoDisplay;
    }

    private JPanel getMessageToolbar() {
        JPanel btns = new JPanel(new FlowLayout());
        btns.add(this.getInsertParameterItemButton());
        return btns;
    }

    private JButton getInsertParameterItemButton() {
        if (this.fBtInsertParameterItemButton == null) {
            this.fBtInsertParameterItemButton = new JButton("InsertParam");
            this.fBtInsertParameterItemButton.setIcon(Global.getIcon("UpArrowColor.gif"));
            this.fBtInsertParameterItemButton.setEnabled(false);
        }
        return this.fBtInsertParameterItemButton;
    }

    private JPanel getBlockListPanel() {
        this.fBjpBlockList = new BorderJPanel(new BorderLayout());
        this.fLstBlockList = new JList();
        this.fLstBlockList.setSelectionMode(0);
        this.fLstBlockList.setCellRenderer(new BlockListCellRenderer(true));
        this.fBjpBlockList.add(new JScrollPane(this.fLstBlockList));
        this.fBjpBlockList.setPreferredSize(new Dimension(300, 300));
        return this.fBjpBlockList;
    }

    private JComponent getMessageDisplayToolBar() {
        JToolBar toolbarPanel = new JToolBar();
        toolbarPanel.setFloatable(false);
        this.fBtClearButton = new RolloverButton(Global.getIcon("Clear.gif"));
        toolbarPanel.add(this.fBtClearButton);
        this.fBtInsertSpecialCharacter = new RolloverButton("\u00b0C");
        toolbarPanel.add(this.fBtInsertSpecialCharacter);
        this.fBtInsertBarButton = new RolloverButton(Global.getIcon("Bar.gif"));
        toolbarPanel.add(this.fBtInsertBarButton);
        this.fBtInsertAIButton = new RolloverButton(" AI");
        toolbarPanel.add(this.fBtInsertAIButton);
        this.fBtInsertIONameButton = new RolloverButton(Global.getIcon("IOname.gif"));
        toolbarPanel.add(this.fBtInsertIONameButton);
        this.fBtInsertSymbolButton = new RolloverButton("Symbol");
        toolbarPanel.add(this.fBtInsertSymbolButton);
        this.fBtScaleTime = new RolloverButton("00:00");
        toolbarPanel.add(this.fBtScaleTime);
        this.fBtEditorButton = new RolloverButton("Edit manually");
        toolbarPanel.add(this.fBtEditorButton);
        return toolbarPanel;
    }

    private void initListeners() {
        this.fLstBlockList.addListSelectionListener(new BlockListSelectionListener());
        ParameterItemSelectionListener parameterItemSelectionListener = new ParameterItemSelectionListener();
        this.fLstParameterItemList.addListSelectionListener(parameterItemSelectionListener);
        this.fLstMessageInternParameterItemList.addListSelectionListener(parameterItemSelectionListener);
        MouseAdapter doubleClickListener = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    MessagePanel.this.insertParameterItemIntoDisplay();
                }
            }
        };
        this.fLstMessageInternParameterItemList.addMouseListener(doubleClickListener);
        this.fLstParameterItemList.addMouseListener(doubleClickListener);
        this.fBtInsertParameterItemButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessagePanel.this.insertParameterItemIntoDisplay();
            }
        });
        this.fBtInsertBarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessagePanel.this.insertBarIntoDisplay();
            }
        });
        this.fBtClearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                List selectedCells = MessagePanel.this.fLogoDisplay.getSelectedCells();
                if (!selectedCells.isEmpty()) {
                    MessagePanel.this.fLogoDisplay.deleteCells(selectedCells);
                } else if (MessagePanel.this.fLogoDisplay.getFocusPosition() != null) {
                    ArrayList<Point> cellList = new ArrayList<Point>(1);
                    cellList.add(MessagePanel.this.fLogoDisplay.getFocusPosition());
                    MessagePanel.this.fLogoDisplay.deleteCells(cellList);
                }
            }
        });
        this.fLogoDisplay.addPropertyChangeListener("insertMode", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                MessagePanel.this.setOverwriteInsertLabel();
            }
        });
        this.fBtInsertSpecialCharacter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessagePanel.this.showInsertSpecialCharacterPopup();
            }
        });
        this.fBtInsertAIButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessagePanel.this.insertAIIntoDisplay();
            }
        });
        this.fBtInsertIONameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessagePanel.this.insertNameIntoDisplay();
            }
        });
        this.fBtInsertSymbolButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessagePanel.this.insertSymbolIntoDisplay();
            }
        });
        this.fOverwriteInsertLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    MessagePanel.this.fLogoDisplay.setInsertMode(!MessagePanel.this.fLogoDisplay.isInsertMode());
                }
            }
        });
        this.fBtEditorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessagePanel.this.showEditor();
            }
        });
        this.fBtScaleTime.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessagePanel.this.insertScaleTimeIntoDisplay();
            }
        });
        this.fBtMessageMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogoError dlg = new LogoError(null, "dialog.parameter.message.gotoMessageMenuSaveCancel", "Do you want to save you changes on this message?", 3, 3);
                int ret = dlg.display();
                if (ret == 1) {
                    return;
                }
                if (ret == 2) {
                    MessagePanel.this.storeFieldContents();
                }
                MessagePanel.this.closeMessagePanel();
                LogoComfort editor = (LogoComfort)Application.getInstance().getActiveApplicationSurface().getEditor();
                editor.editMessageGlobalSetting();
            }
        });
    }

    private void closeMessagePanel() {
        for (Container c = this.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof SplittedDlg)) continue;
            ((SplittedDlg)c).dispose();
            break;
        }
    }

    private void showEditor() {
        if (!(this.fLogoDisplay.getModel() instanceof MessageParameterDisplayModelRTF)) {
            return;
        }
        MessageEditorPanel editorPanel = new MessageEditorPanel((MessageParameterDisplayModelRTF)this.fLogoDisplay.getModel());
        SplittedDlg dialog = SplittedDlg.create(Application.getInstance().getActiveApplicationSurface().getWindow(), editorPanel, 3);
        dialog.show();
        if (dialog.getControlPanel().getResult() == 1) {
            this.fLogoDisplay.repaint();
        }
    }

    protected void showInsertSpecialCharacterPopup() {
        if (this.fInsertSpecialCharacterPopupWindow == null) {
            Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.fBtInsertSpecialCharacter);
            if (window == null) {
                return;
            }
            this.fInsertSpecialCharacterPopupWindow = new PopupWindow(window);
            ((JComponent)this.fInsertSpecialCharacterPopupWindow.getContentPane()).setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.fInsertSpecialCharacterPopupWindow.getContentPane().add(this.fInsertSpecialCharactersPanel);
        }
        this.fInsertSpecialCharactersPanel.setSize(100, 10);
        this.fInsertSpecialCharacterPopupWindow.setSize(this.fInsertSpecialCharactersPanel.getPreferredSize());
        this.fInsertSpecialCharacterPopupWindow.pack();
        this.fInsertSpecialCharacterPopupWindow.show(this.fBtInsertSpecialCharacter, new Rectangle(0, this.fBtInsertSpecialCharacter.getSize().height, this.fInsertSpecialCharactersPanel.getSize().width + 5, this.fInsertSpecialCharactersPanel.getSize().height + 5));
    }

    private void setOverwriteInsertLabel() {
        this.fOverwriteInsertLabel.setEnabled(!this.fLogoDisplay.isInsertMode());
    }

    protected void insertParameterItemIntoDisplay() {
        ParameterItem parameterItem = null;
        if (this.fLstMessageInternParameterItemList.getSelectedValue() != null) {
            parameterItem = (ParameterItem)this.fLstMessageInternParameterItemList.getSelectedValue();
        }
        if (this.fLstParameterItemList.getSelectedValue() != null) {
            parameterItem = (ParameterItem)this.fLstParameterItemList.getSelectedValue();
        }
        if (parameterItem == null) {
            return;
        }
        if (this.fLogoDisplay.getModel() instanceof MessageParameterDisplayModelRTF && !((MessageParameterDisplayModelRTF)this.fLogoDisplay.getModel()).checkElementRestriction(parameterItem)) {
            this.notifyExceedMaxCountError(parameterItem);
            return;
        }
        boolean inserted = this.fLogoDisplay.getModel().setElementAt(parameterItem, this.fLogoDisplay.getFocusPosition());
        if (!inserted) {
            if (this.fLogoDisplay.getModel() instanceof MessageParameterDisplayModelPlain) {
                LogoError message = new LogoError(this, "dialog.parameter.message.insertionNotAllowed", "Insertion is not allowed on the current position.", 2);
                message.display();
            } else {
                this.fLogoDisplay.showManualEditPanel(false, null, parameterItem, null);
            }
        }
    }

    private void notifyExceedMaxCountError(DisplayElement displayElement) {
        MessageParameterDisplayModelRTF model = (MessageParameterDisplayModelRTF)this.fLogoDisplay.getModel();
        String errString = model.getErrorInsertString();
        if (errString != null) {
            LogoError message = new LogoError(this, errString, "Exceed count restriction in one message text.", 2);
            message.setAdditionalInformation(model.getMaxItemCount(displayElement));
            message.display();
        }
    }

    protected void insertAIIntoDisplay() {
        WiringDiagram wd = ((MessageParameter)this.getParameterReference()).getBlock().getWiringDiagram();
        Object[] aiList = wd.getBlockNumberList(11, 2);
        if (aiList.length == 0) {
            LogoError message = new LogoError(this, "dialog.parameter.message.setAIError", "No AI in the user program", 0);
            message.display();
            return;
        }
        AIDisplayElement aiDisp = new AIDisplayElement(((MessageParameter)this.getParameterReference()).getBlock().getWiringDiagram(), 0);
        if (!((MessageParameterDisplayModelRTF)this.fLogoDisplay.getModel()).checkElementRestriction(aiDisp)) {
            this.notifyExceedMaxCountError(aiDisp);
            return;
        }
        Object ret = JOptionPane.showInputDialog(null, Language.getString("dialog.parameter.message.setAIContents", "AI number?"), Language.getString("dialog.parameter.message.setAITitle", "Select AI"), 3, null, aiList, aiList[0]);
        if (ret == null) {
            return;
        }
        try {
            int AINumber = Integer.parseInt(((String)ret).substring(2));
            aiDisp.setAINumber(AINumber);
        }
        catch (Exception e) {
            return;
        }
        boolean inserted = this.fLogoDisplay.getModel().setElementAt(aiDisp, this.fLogoDisplay.getFocusPosition());
        if (!inserted) {
            this.fLogoDisplay.showManualEditPanel(false, null, aiDisp, null);
        }
    }

    protected void insertNameIntoDisplay() {
        int nameID = this.getMessageManager().getFreeID(MessageLineRTF.STATUS_NAME_IO_ID, ((MessageParameter)this.getParameterReference()).getBlock(), this.getCurrentlyUsedIDs(IONameDisplayElement.class));
        String[] options = new String[]{String.valueOf(this.getMessageManager().getMaxIDResource(MessageLineRTF.STATUS_NAME_IO_ID))};
        if (nameID == -1) {
            LogoError message = new LogoError((Component)this, "dialog.parameter.message.ioNameNotAvailable", "The maximum number of I/O status name items is %.", 2, options);
            message.setAdditionalInformation(this.getMessageManager().getWiringDiagram().getHardware().getIntProperty("RTFMaxIOStatusItemTotal"));
            message.display();
            return;
        }
        System.out.println("nameID: " + nameID);
        IONameDisplayElement nameDisp = new IONameDisplayElement(((MessageParameter)this.getParameterReference()).getBlock().getWiringDiagram(), nameID, -1, -1);
        if (!((MessageParameterDisplayModelRTF)this.fLogoDisplay.getModel()).checkElementRestriction(nameDisp)) {
            this.notifyExceedMaxCountError(nameDisp);
            return;
        }
        nameDisp.setNameByte(0, new int[]{79, 70, 70});
        nameDisp.setNameByte(1, new int[]{79, 78});
        nameDisp.setCharSet(((MutiCharSetDisplayModel)((Object)this.fLogoDisplay.getModel())).getCharSet());
        IONameSettingPanel ioPanel = new IONameSettingPanel(this.fLogoDisplay, nameDisp, ((MessageParameter)this.getParameterReference()).getBlock().getWiringDiagram());
        SplittedDlg dialog = SplittedDlg.create(Application.getInstance().getActiveApplicationSurface().getWindow(), ioPanel, 3);
        dialog.show();
        if (dialog.getControlPanel().getResult() != 1 || nameDisp.getNumber() == -1) {
            return;
        }
        boolean inserted = this.fLogoDisplay.getModel().setElementAt(nameDisp, this.fLogoDisplay.getFocusPosition());
        if (!inserted) {
            this.fLogoDisplay.showManualEditPanel(false, dialog, nameDisp, null);
        }
    }

    protected void insertSymbolIntoDisplay() {
        LogoError dialog;
        int charset = this.getMsgGlobalInfo().getSelectedCharSet(this.fPanelTextID);
        if (this.fSymbolPanel == null) {
            this.fCellsTransferable = new LogoDisplay.CellsTransferable();
            this.fSymbolPanel = new SymbolInsertPanel(this.fLogoDisplay, charset, this.fCellsTransferable);
        } else if (charset != this.fSymbolPanel.getCharset()) {
            this.fSymbolPanel.setCharset(charset);
        }
        SplittedDlg sDialog = SplittedDlg.create(Application.getInstance().getActiveApplicationSurface().getWindow(), this.fSymbolPanel, 33);
        sDialog.show();
        if (sDialog.getControlPanel().getResult() != 1) {
            return;
        }
        boolean inserted = this.fLogoDisplay.getModel().paste(this.fCellsTransferable, this.fLogoDisplay.getFocusPosition());
        if (!inserted && (dialog = new LogoError(null, "dialog.logdisplay.conflictOccure", "Position conflict with another message text element.\n Edit manually?", 1, 1)).display() == 0) {
            MessageEditorPanel editorPanel = new MessageEditorPanel((MessageParameterDisplayModelRTF)this.fLogoDisplay.getModel());
            editorPanel.setClipboardContent(this.fCellsTransferable);
            SplittedDlg panel = SplittedDlg.create(Application.getInstance().getActiveApplicationSurface().getWindow(), editorPanel, 3);
            panel.show();
            if (panel.getControlPanel().getResult() == 1) {
                this.fLogoDisplay.repaint();
            }
        }
    }

    protected void insertBarIntoDisplay() {
        BarDisplayElement bar = null;
        int barID = this.getMessageManager().getFreeID(MessageLineRTF.BAR_ID, ((MessageParameter)this.getParameterReference()).getBlock(), this.getCurrentlyUsedIDs(BarDisplayElement.class));
        if (barID == -1) {
            LogoError message = new LogoError(this, "dialog.parameter.message.barNotAvailable", "Max bar item is 32.", 0);
            message.display();
            return;
        }
        bar = new BarDisplayElement(barID, null, 0, 1, 1000, 0);
        if (!((MessageParameterDisplayModelRTF)this.fLogoDisplay.getModel()).checkElementRestriction(bar)) {
            this.notifyExceedMaxCountError(bar);
            return;
        }
        BarDisplaySettingPanel barDisplaySettingPanel = new BarDisplaySettingPanel(false, this.fLogoDisplay, bar, ((MessageParameter)this.getParameterReference()).getBlock().getWiringDiagram());
        if (!barDisplaySettingPanel.isAvailable()) {
            this.notifyNoActualValue();
            return;
        }
        SplittedDlg dialog = SplittedDlg.create(Application.getInstance().getActiveApplicationSurface().getWindow(), barDisplaySettingPanel, 3);
        barDisplaySettingPanel.setDialog(dialog);
        dialog.show();
    }

    private void notifyNoActualValue() {
        LogoError message = new LogoError(this, "dialog.parameter.message.setBarError", "No block contains actual value in the user program", 0);
        message.display();
    }

    private void insertScaleTimeIntoDisplay() {
        ScaleTimeDisplayElement scale = new ScaleTimeDisplayElement();
        if (!((MessageParameterDisplayModelRTF)this.fLogoDisplay.getModel()).checkElementRestriction(scale)) {
            this.notifyExceedMaxCountError(scale);
            return;
        }
        WiringDiagram wd = ((MessageParameter)this.getParameterReference()).getBlock().getWiringDiagram();
        ScaleTimeSettingPanel panel = new ScaleTimeSettingPanel(wd, scale);
        if (!panel.isAvailable()) {
            this.notifyNoActualValue();
            return;
        }
        SplittedDlg dialog = SplittedDlg.create(Application.getInstance().getActiveApplicationSurface().getWindow(), panel, 3);
        dialog.show();
        if (dialog.getControlPanel().getResult() != 1 || scale.getParameterItem() == null) {
            return;
        }
        boolean inserted = this.fLogoDisplay.getModel().setElementAt(scale, this.fLogoDisplay.getFocusPosition());
        if (!inserted) {
            this.fLogoDisplay.showManualEditPanel(false, dialog, scale, null);
        }
    }

    private Vector getCurrentlyUsedIDs(Class type) {
        Vector<Integer> ret = new Vector<Integer>();
        DisplayElement dispElement = null;
        for (int index = 0; index < this.fSettingInfo.length; ++index) {
            if (this.fSettingInfo[index] == null) continue;
            MessageDisplayModel model = this.fSettingInfo[index].displayModel;
            for (int i = 0; i < model.getDisplayDimension().width; ++i) {
                for (int j = 0; j < model.getDisplayDimension().height; ++j) {
                    dispElement = model.getElementAt(new Point(i, j));
                    if (dispElement == null || dispElement.getClass() != type) continue;
                    ret.addElement(((MessageResource)((Object)dispElement)).getID());
                }
            }
        }
        return ret;
    }

    private void initDragAndDrop() {
        this.fLstParameterItemList.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent me) {
                TransferHandler th = MessagePanel.this.fLstParameterItemList.getTransferHandler();
                th.exportAsDrag(MessagePanel.this.fLstParameterItemList, me, 1);
            }
        });
        this.fLstMessageInternParameterItemList.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent me) {
                TransferHandler th = MessagePanel.this.fLstMessageInternParameterItemList.getTransferHandler();
                th.exportAsDrag(MessagePanel.this.fLstMessageInternParameterItemList, me, 1);
            }
        });
        this.fLstParameterItemList.setTransferHandler(new ParameterItemTransferHandler());
        this.fLstMessageInternParameterItemList.setTransferHandler(new ParameterItemTransferHandler());
        this.fLogoDisplay.setDropEnabled(true);
        this.fLogoDisplay.setDragEnabled(true);
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        MessageParameter parameter = (MessageParameter)this.getParameterReference();
        Hardware currentHardware = parameter.getBlock().getWiringDiagram().getHardware();
        WiringDiagram wd = parameter.getBlock().getWiringDiagram();
        Enumeration blockEnum = wd.getBlocks().elements();
        Vector<Block> blocks = new Vector<Block>();
        while (blockEnum.hasMoreElements()) {
            BlockParameter blockParameter;
            Block block = (Block)blockEnum.nextElement();
            if (wd.getMacroBlock(block) != null || (blockParameter = block.getParameter()) == null || blockParameter.getParameterItems().getPublicParameterItemList().isEmpty()) continue;
            blocks.addElement(block);
        }
        Collections.sort(blocks, new BlockByNumberComparator());
        this.fLstBlockList.setListData(blocks);
        this.setPriorityValues();
        this.fChBoReceipt.setSelected(parameter.isReceipt());
        this.fChBoReceipt.setEnabled(currentHardware.supports("messageBlockWithReceipt"));
        this.fBtInsertSpecialCharacter.setVisible(currentHardware.supports("mixedMessageTextAndParameter"));
        this.fillPrivateParameterList();
        if (this.fLstMessageInternParameterItemList.getModel().getSize() == 0) {
            this.fLstMessageInternParameterItemList.setVisible(false);
        }
        this.setOverwriteInsertLabel();
        if (this.isRTFMessage()) {
            this.fPanelTextID = parameter.getCurrentTextID();
            this.fCurrentlyCharacterSet[this.fPanelTextID].setSelected(true);
            this.fTextID = new int[2];
            this.fSettingInfo = new ControlsSettingInfo[2];
            for (int i = 0; i < 2; ++i) {
                if (parameter.getMessageRTF(i) != null) {
                    this.fSettingInfo[i] = new ControlsSettingInfo(parameter, i);
                    this.fTextID[i] = parameter.getMessageRTF(i).getTextID();
                    this.fChkCharSetEnabled[i].setSelected(true);
                    continue;
                }
                this.fCurrentlyCharacterSet[i].setEnabled(false);
                this.fTextID[i] = this.getMessageManager().getFreeMessageTextID();
                this.fChkCharSetEnabled[i].setSelected(false);
            }
            this.fSettingInfo[this.fPanelTextID].setControlsStatus();
            this.fChkPrintDetail.setSelected(parameter.getParameterTextMode());
        } else {
            this.fDisplayModel = new MessageParameterDisplayModelPlain(parameter);
            this.fLogoDisplay.setModel(this.fDisplayModel);
            this.fBtMessageMenu.setVisible(currentHardware.supports("supportAsiaLanguage"));
        }
        for (Integer specialCharacterCode : this.fDisplayModel.getSpecialCharactersTable().keySet()) {
            String displayedText = (String)this.fDisplayModel.getSpecialCharactersTable().get(specialCharacterCode);
            InsertSpecialCharacterButton button = new InsertSpecialCharacterButton(displayedText, (int)specialCharacterCode);
            this.fInsertSpecialCharactersPanel.add(button);
        }
    }

    public JPanel getParameterPanel() {
        return this.fParameterPanel;
    }

    public Dimension getPreferredSize() {
        int preferredHeight = 550;
        if (this.isRTFMessage()) {
            preferredHeight = 700;
        }
        return new Dimension(this.fLogoDisplay.getPreferredSize().width + 350, preferredHeight);
    }

    private boolean isRTFMessage() {
        return this.getMessageManager().isRTFMessage();
    }

    private MessageManager getMessageManager() {
        MessageParameter parameter = (MessageParameter)this.getParameterReference();
        MessageManager msgManager = parameter.getBlock().getWiringDiagram().getMessageManager();
        return msgManager;
    }

    private MessageGlobalInfo getMsgGlobalInfo() {
        MessageParameter parameter = (MessageParameter)this.getParameterReference();
        MessageGlobalInfo msgInfo = parameter.getBlock().getWiringDiagram().getMessageGlobalInfo();
        return msgInfo;
    }

    protected class BlockListSelectionListener
    implements ListSelectionListener {
        protected BlockListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (MessagePanel.this.fLstBlockList.getSelectedIndex() != -1) {
                MessagePanel.this.fillParameterList();
            }
        }
    }

    public static class ParameterItemListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                return this;
            }
            ParameterItem parameterItem = (ParameterItem)value;
            this.setText(parameterItem.getLocalisedName());
            ImageIcon icon = null;
            if (parameterItem.getParameterValueType() == 1 && !parameterItem.isEditable()) {
                icon = Global.getIcon("Refresh.gif");
            }
            if (parameterItem.getParameterValueType() == 1 && parameterItem.isEditable()) {
                icon = Global.getIcon("RefreshEditable.gif");
            }
            if (parameterItem.getParameterValueType() != 1 && parameterItem.isEditable()) {
                icon = Global.getIcon("Editable.gif");
            }
            if (parameterItem.getParameterValueType() == 2) {
                icon = Global.getIcon("Refresh.gif");
            }
            this.setIcon(icon);
            return this;
        }
    }

    protected class ParameterItemTransferHandler
    extends TransferHandler {
        protected ParameterItemTransferHandler() {
        }

        protected Transferable createTransferable(JComponent c) {
            if (c instanceof JList) {
                return this.createTransferableFromList((JList)c);
            }
            return null;
        }

        private Transferable createTransferableFromList(JList list) {
            Object[] selectedValues = list.getSelectedValues();
            if (selectedValues == null || selectedValues.length != 1) {
                return null;
            }
            if (!(selectedValues[0] instanceof ParameterItem)) {
                return null;
            }
            ParameterItem parameterItem = (ParameterItem)selectedValues[0];
            return new LogoDisplay.DisplayElementTransferable(parameterItem);
        }

        public int getSourceActions(JComponent c) {
            return 3;
        }

        public Icon getVisualRepresentation(Transferable t) {
            if (!(t instanceof LogoDisplay.DisplayElementTransferable)) {
                return super.getVisualRepresentation(t);
            }
            return Global.getIcon("Delete.gif");
        }
    }

    protected class InsertSpecialCharacterButton
    extends RolloverButton
    implements ActionListener {
        private int fCharCode;

        public InsertSpecialCharacterButton(String displayedText, int charCode) {
            super(displayedText);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.fCharCode = charCode;
            this.addActionListener(this);
        }

        public InsertSpecialCharacterButton(char displayedCharacter, int charCode) {
            this(Character.toString(displayedCharacter), charCode);
        }

        public void actionPerformed(ActionEvent e) {
            int width = 1;
            if (MessagePanel.this.isRTFMessage() && MessageGlobalInfo.isBiWidthCharSet(MessagePanel.this.getMsgGlobalInfo().getSelectedCharSet(MessagePanel.this.fPanelTextID))) {
                width = 2;
            }
            SpecialCharacterDisplayElement specialCharacterDisplayElement = new SpecialCharacterDisplayElement(this.getText(), this.fCharCode, width, 1);
            MessagePanel.this.fLogoDisplay.getModel().setElementAt(specialCharacterDisplayElement, MessagePanel.this.fLogoDisplay.getFocusPosition());
            MessagePanel.this.fInsertSpecialCharacterPopupWindow.dispose();
        }
    }

    protected class ParameterItemSelectionListener
    implements ListSelectionListener {
        protected ParameterItemSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() == MessagePanel.this.fLstParameterItemList && MessagePanel.this.fLstParameterItemList.getSelectedValue() != null) {
                MessagePanel.this.fLstMessageInternParameterItemList.clearSelection();
            }
            if (e.getSource() == MessagePanel.this.fLstMessageInternParameterItemList && MessagePanel.this.fLstMessageInternParameterItemList.getSelectedValue() != null) {
                MessagePanel.this.fLstParameterItemList.clearSelection();
            }
            MessagePanel.this.fBtInsertParameterItemButton.setEnabled(((JList)e.getSource()).getSelectedValue() != null);
        }
    }

    protected class ParameteringDisplayToolTipProvider
    implements DisplayToolTipProvider {
        protected ParameteringDisplayToolTipProvider() {
        }

        public String getToolTipText(LogoDisplay display, DisplayElement displayElement) {
            if (displayElement instanceof ParameterItem) {
                ParameterItem parameterItem = (ParameterItem)displayElement;
                return this.getParameterToolTipString(parameterItem);
            }
            if (displayElement instanceof BarDisplayElement) {
                BarDisplayElement bar = (BarDisplayElement)displayElement;
                String ret = this.getParameterToolTipString(bar.getParameterItem());
                int insertPos = "<html><b>".length();
                String barName = Language.getString("dialog.parameter.message.itemName.barGraph", "Bar graph");
                return ret.substring(0, insertPos) + barName + " - " + ret.substring(insertPos);
            }
            if (displayElement instanceof IONameDisplayElement) {
                IONameDisplayElement ioName = (IONameDisplayElement)displayElement;
                String ioItemName = Language.getString("dialog.parameter.message.itemName.ioName", "IO name");
                return ioItemName + " - " + ioName.getBlock().getLocalizedName(true);
            }
            if (displayElement instanceof AIDisplayElement) {
                AIDisplayElement aiDisp = (AIDisplayElement)displayElement;
                String aiName = Language.getString("dialog.parameter.message.itemName.AIFilter", "AI filter");
                return aiName + " - " + aiDisp.getBlock().getLocalizedName(true);
            }
            if (displayElement instanceof ScaleTimeDisplayElement) {
                ScaleTimeDisplayElement scale = (ScaleTimeDisplayElement)displayElement;
                String ret = this.getParameterToolTipString(scale.getParameterItem());
                int insertPos = "<html><b>".length();
                String scaleName = Language.getString("dialog.parameter.message.itemName.scaleTime", "Scale time");
                return ret.substring(0, insertPos) + scaleName + " - " + ret.substring(insertPos);
            }
            return null;
        }

        private String getParameterToolTipString(ParameterItem parameterItem) {
            String actualUrlString;
            BlockParameter parameter = parameterItem.getParameter();
            boolean editable = parameterItem.isEditable() && !MessagePanel.this.cbProtection.isSelected();
            StringBuffer tooltip = new StringBuffer("<html><b>");
            tooltip.append(parameter.getBlock().getNumberString()).append(" " + parameterItem.getLocalisedName()).append("</b>");
            if (parameterItem.getParameterValueType() == 1) {
                actualUrlString = this.getClass().getResource("/DE/siemens/ad/logo/images/Refresh.gif").toString();
                tooltip.append("<img src=\"").append(actualUrlString).append("\" alt=\"actual value\">");
            }
            if (parameterItem.getParameterValueType() == 2) {
                actualUrlString = this.getClass().getResource("/DE/siemens/ad/logo/images/Refresh.gif").toString();
                tooltip.append("<img src=\"").append(actualUrlString).append("\" alt=\"rest time\">");
            }
            if (editable && parameter instanceof ProtectionParameter && ((ProtectionParameter)parameter).getProtection()) {
                editable = false;
            }
            if (editable) {
                String cutUrlString = this.getClass().getResource("/DE/siemens/ad/logo/images/Editable.gif").toString();
                tooltip.append("<img src=\"").append(cutUrlString).append("\" alt=\"editable\">");
            }
            return tooltip.append("</html>").toString();
        }
    }

    protected class ControlsSettingInfo {
        public int tickType;
        public boolean[] isTickerLine;
        public int showDest;
        public int blockIndex;
        public int parameterIndex;
        public int internalParameterIndex;
        public MessageDisplayModel displayModel;
        protected int fCharSetID;

        public ControlsSettingInfo(MessageParameter param, int charSetID) {
            this.isTickerLine = new boolean[MessagePanel.this.fChkLineTickerFlags.length];
            MessageParameter.MessageText msgText = param.getMessageRTF(charSetID);
            for (int i = 0; i < this.isTickerLine.length; ++i) {
                this.isTickerLine[i] = msgText.getMessageLineRTF()[i].isTickerLine();
            }
            this.showDest = msgText.getShowDest();
            this.tickType = msgText.getTickerType();
            this.displayModel = new MessageParameterDisplayModelRTF(param, charSetID);
            this.blockIndex = -1;
            this.parameterIndex = -1;
            this.fCharSetID = charSetID;
        }

        public ControlsSettingInfo(MessageParameter param, int charSetID, int nullObject) {
            this.isTickerLine = new boolean[MessagePanel.this.fChkLineTickerFlags.length];
            for (int i = 0; i < this.isTickerLine.length; ++i) {
                this.isTickerLine[i] = false;
            }
            this.showDest = 3;
            this.tickType = 0;
            this.displayModel = new MessageParameterDisplayModelRTF(param, charSetID);
            this.blockIndex = -1;
            this.parameterIndex = -1;
            this.fCharSetID = charSetID;
        }

        public void storeInfoToParameter(MessageParameter param) {
            MessageParameter.MessageText oldMessageText = param.getMessageRTF(this.fCharSetID);
            if (oldMessageText != null) {
                oldMessageText.clearMapInfo();
            }
            int charSet = param.getBlock().getWiringDiagram().getMessageGlobalInfo().getSelectedCharSet(this.fCharSetID);
            MessageParameter.MessageText newMessageText = new MessageParameter.MessageText(MessagePanel.this.fTextID[this.fCharSetID], charSet, param);
            MessageManager.fillMessageLineRTFsFromDisplayModel(newMessageText, this.displayModel);
            newMessageText.setTickerType(this.tickType);
            newMessageText.setShowDest(this.showDest);
            for (int i = 0; i < this.isTickerLine.length; ++i) {
                newMessageText.getMessageLineRTF()[i].setTickerLine(this.isTickerLine[i]);
            }
            param.setMessageRTF(newMessageText, this.fCharSetID);
        }

        public void setControlsStatus() {
            if (this.showDest > 0) {
                MessagePanel.this.fOptionDest[this.showDest - 1].setSelected(true);
            }
            for (int i = 0; i < MessagePanel.this.fChkLineTickerFlags.length; ++i) {
                MessagePanel.this.fChkLineTickerFlags[i].setSelected(this.isTickerLine[i]);
            }
            MessagePanel.this.fOptionTickTypes[this.tickType].setSelected(true);
            MessagePanel.this.fLstBlockList.setSelectedIndex(this.blockIndex);
            MessagePanel.this.fLstParameterItemList.setSelectedIndex(this.parameterIndex);
            MessagePanel.this.fLstMessageInternParameterItemList.setSelectedIndex(this.internalParameterIndex);
            MessagePanel.this.fDisplayModel = this.displayModel;
            MessagePanel.this.fLogoDisplay.setModel(MessagePanel.this.fDisplayModel);
            MessagePanel.this.fDisplayModel.setInsertMode(MessagePanel.this.fLogoDisplay.isInsertMode());
        }

        public void saveControlsStatus() {
            int i;
            for (i = 0; i < MessagePanel.this.fOptionDest.length; ++i) {
                if (!MessagePanel.this.fOptionDest[i].isSelected()) continue;
                this.showDest = i + 1;
            }
            for (i = 0; i < MessagePanel.this.fChkLineTickerFlags.length; ++i) {
                this.isTickerLine[i] = MessagePanel.this.fChkLineTickerFlags[i].isSelected();
            }
            for (i = 0; i < MessagePanel.this.fOptionTickTypes.length; ++i) {
                if (!MessagePanel.this.fOptionTickTypes[i].isSelected()) continue;
                this.tickType = i;
            }
            this.blockIndex = MessagePanel.this.fLstBlockList.getSelectedIndex();
            this.parameterIndex = MessagePanel.this.fLstParameterItemList.getSelectedIndex();
            this.internalParameterIndex = MessagePanel.this.fLstMessageInternParameterItemList.getSelectedIndex();
        }
    }
}

